 ; Ŀ
 ;   300 - search and replace text strings (not attributes) in blocks.     
 ;   Copyright 2009 by Rocket Software Ltd.                                
 ;   Would you believe me if I said you were gullible?                     
 ; 

 ; Ŀ
 ;   Stex - search and replace text strings in a block definition.         
 ;   Arguments: Blnam, a block name.                                       
 ;              Newstr, the new text string.                               
 ;   Returns a list: (number_of_text_changed  number_of_changes)           
 ; 
 (DEFUN STEX (blnam oldstr newstr cas / blok enam txtchg changs entt str
                                                   asoc1 chugs chnum ok)
  (setq blok (tblsearch "block" blnam))           ; head entity from table
  (setq enam (cdr (assoc -2 blok)))               ; first ename after head
  (setq txtchg 0)
  (setq changs 0)
  (while (setq enam (entnext enam))
         (setq entt (entget enam))
         (if (= (cdr (assoc 0 entt)) "TEXT")     ; if it's text
             (progn
                  (setq str (cdr (setq asoc1 (assoc 1 entt))))
                  (if cas
                      (setq chugs (chug oldstr newstr str))
                      (setq chugs (chug (strcase oldstr)
                                            newstr (strcase str))))
                  (if (not (zerop (setq chnum (cadr chugs))))
                      (progn
                           (setq txtchg (1+ txtchg))
                           (setq changs (+ changs chnum))
                           (entmod (subst (cons 1 (car chugs)) asoc1 entt))
                           (setq ok t))))))
 (list txtchg changs))
 ; Ŀ
 ;   Stex end.                                                             
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen oldlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   300.                                                                  
 ; 
 (DEFUN C:300 (/ oldstr newstr cas blchg txtchg changs rew llist blnam chgs
                                                                    pa chgper)
  (setvar "cmdecho" 0)
  (setq oldstr "300")
  (setq newstr "ON")
 ; Ŀ
 ;   Case sensitive?  (t = yes, nil = no)                                  
 ; 
  (setq cas t)
 ; Ŀ
 ;   Zero a few count and operator error probability evaluation variables. 
 ; 
  (setq blchg 0)   ; number of blocks changed
  (setq txtchg 0)  ; number of text subentities changed
  (setq changs 0)  ; total number of changes
 ; Ŀ
 ;   Step through the layer tables.                                        
 ; 
  (setq rew t)
  (while (setq llist (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 llist)))
 ; Ŀ
 ;   Call Stex to update text.                                             
 ; 
         (if (not (zerop (car (setq chgs (stex blnam oldstr newstr cas)))))
             (progn
                  (setq blchg (1+ blchg))
                  (setq txtchg (+ txtchg (car chgs)))
                  (setq changs (+ changs (cadr chgs))))))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (if (> blchg 0)
      (progn
 ; Ŀ
 ;   If anything was changed, regenerate the drawing.                      
 ; 
           (command ".regen")
           (setq chgper (/ changs txtchg 1.0))
           (prompt (strcat (itoa changs) " Change" (if (= changs 1) "" "s")
                           " in " (itoa txtchg) " Text"
                                  (if (= txtchg 1) "" "s")
                           " in " (itoa blchg) " Block Definition"
                                  (if (= blchg 1) "" "s")
                           ". Changes/Text: " (rtos chgper 2 2)))
           (if (/= 1 chgper)
               (progn
                    (prompt "\n*** You Have Probably Made A Mistake. ***")
                    (if (load "skx" ())
                        (progn
                             (setq pa (cadr (grread t)))
                             (sk pa 0.25)
                             (sk (getvar "viewctr") 0.25))))))
      (prompt "\nNo Changes Made."))
 (princ))